/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.git.core.model.ChangedFile;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.DiffFormatter;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommitDialog
extends StatusDialog {
    private static final String COMMIT_DIALOG_CONTEXT_ID = "com.aptana.git.ui.context.dialog.commit";
    private static final String PERFORM_COMMIT_COMMAND_ID = "com.aptana.git.ui.command.commit.dialog";
    private static final String CHANGED_FILE_DATA_KEY = "changedFile";
    private GitRepository gitRepository;
    private Text commitMessage;
    private String fMessage;
    private Table unstagedTable;
    private Table stagedTable;
    private Control draggingFromTable;
    private Image newFileImage;
    private Image deletedFileImage;
    private Image emptyFileImage;
    private Scrollable diffArea;
    private ChangedFile fLastDiffFile;
    private StagingButtons unstageButtons;
    private StagingButtons stageButtons;
    private IContextActivation contextActivation;
    private IHandlerActivation commitHandler;

    protected CommitDialog(Shell parentShell, GitRepository gitRepository) {
        super(parentShell);
        Assert.isNotNull((Object)gitRepository, (String)"Must have a non-null git repository!");
        this.gitRepository = gitRepository;
        this.newFileImage = GitUIPlugin.getImage("icons/obj16/new_file.png");
        this.deletedFileImage = GitUIPlugin.getImage("icons/obj16/deleted_file.png");
        this.emptyFileImage = GitUIPlugin.getImage("icons/obj16/empty_file.png");
        this.fLastDiffFile = null;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName;
        IDialogSettings compareSettings = GitUIPlugin.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = compareSettings.getSection(sectionName = ((Object)((Object)this)).getClass().getName());
        if (dialogSettings == null) {
            dialogSettings = compareSettings.addNewSection(sectionName);
        }
        return dialogSettings;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        parent.getShell().setText(MessageFormat.format(Messages.CommitDialog_Changes, this.gitRepository.currentBranch()));
        container.setLayout((Layout)new GridLayout(1, true));
        this.createDiffArea(container);
        SashForm sashForm = new SashForm(container, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        sashForm.setLayout((Layout)new FillLayout());
        this.createUnstagedFileArea(sashForm);
        this.createCommitMessageArea(sashForm);
        this.createStagedFileArea(sashForm);
        sashForm.setSashWidth(5);
        sashForm.setWeights(new int[]{35, 30, 35});
        this.validate();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                CommitDialog.this.packTable(CommitDialog.this.stagedTable);
                CommitDialog.this.packTable(CommitDialog.this.unstagedTable);
                if (CommitDialog.this.unstagedTable.getItemCount() > 0) {
                    CommitDialog.this.unstagedTable.select(0);
                    ChangedFile file = CommitDialog.this.getChangedFile(CommitDialog.this.unstagedTable.getItem(0));
                    CommitDialog.this.updateDiff(false, file);
                    CommitDialog.this.stageButtons.updateSelectionButton();
                } else if (CommitDialog.this.stagedTable.getItemCount() > 0) {
                    CommitDialog.this.stagedTable.select(0);
                    ChangedFile file = CommitDialog.this.getChangedFile(CommitDialog.this.stagedTable.getItem(0));
                    CommitDialog.this.updateDiff(true, file);
                    CommitDialog.this.unstageButtons.updateSelectionButton();
                }
            }
        });
        return container;
    }

    public void create() {
        super.create();
        this.validate();
    }

    protected Point getInitialSize() {
        IDialogSettings dialogSettings = this.getDialogBoundsSettings();
        try {
            dialogSettings.getInt("DIALOG_WIDTH");
        }
        catch (NumberFormatException e) {
            Composite parent = this.getShell().getParent();
            Monitor monitor = this.getShell().getDisplay().getPrimaryMonitor();
            if (parent != null) {
                monitor = parent.getMonitor();
            }
            Rectangle monitorBounds = monitor.getClientArea();
            return new Point((int)(0.618 * (double)monitorBounds.width), (int)(0.618 * (double)monitorBounds.height));
        }
        return super.getInitialSize();
    }

    private void createDiffArea(Composite container) {
        try {
            this.diffArea = new Browser(container, 2048);
        }
        catch (SWTError e) {
            this.diffArea = new Text(container, 2050);
        }
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 300;
        this.diffArea.setLayoutData((Object)data);
        this.setDiffText(Messages.CommitDialog_NoFileSelected);
    }

    private void setDiffText(String msg) {
        if (this.diffArea instanceof Browser) {
            ((Browser)this.diffArea).setText(msg);
        } else {
            ((Text)this.diffArea).setText(msg);
        }
    }

    private void createUnstagedFileArea(SashForm sashForm) {
        this.createFileArea(sashForm, false);
    }

    private void createStagedFileArea(SashForm sashForm) {
        this.createFileArea(sashForm, true);
    }

    private void createFileArea(SashForm sashForm, boolean staged) {
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        StagingButtons buttons = null;
        if (staged) {
            buttons = new StagingButtons(composite, Messages.CommitDialog_UnstageAllMarker, Messages.CommitDialog_UnstageAll, Messages.CommitDialog_UnstageSelectedMarker, Messages.CommitDialog_UnstageSelected);
            this.createTableComposite(composite, staged);
            buttons.setTable(this.stagedTable, staged);
            this.unstageButtons = buttons;
        } else {
            this.createTableComposite(composite, staged);
            buttons = new StagingButtons(composite, Messages.CommitDialog_StageAllMarker, Messages.CommitDialog_StageAll, Messages.CommitDialog_StageSelectedMarker, Messages.CommitDialog_StageSelected);
            buttons.setTable(this.unstagedTable, staged);
            this.stageButtons = buttons;
        }
    }

    private Composite createTableComposite(Composite parent, boolean staged) {
        Composite tableComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 1;
        layout.marginWidth = 1;
        tableComp.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 250;
        tableComp.setLayoutData((Object)data);
        Label label = new Label(tableComp, 0);
        Table table = null;
        if (staged) {
            label.setText(Messages.CommitDialog_StagedChanges);
            table = this.createTable(tableComp, true);
        } else {
            label.setText(Messages.CommitDialog_UnstagedChanges);
            table = this.createTable(tableComp, false);
        }
        if (staged) {
            this.stagedTable = table;
        } else {
            this.unstagedTable = table;
        }
        return tableComp;
    }

    private void createCommitMessageArea(SashForm sashForm) {
        Composite msgComp = new Composite((Composite)sashForm, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        msgComp.setLayout((Layout)layout);
        Label messageLabel = new Label(msgComp, 0);
        messageLabel.setText(Messages.CommitDialog_MessageLabel);
        this.commitMessage = new Text(msgComp, 2626);
        this.commitMessage.setText(this.gitRepository.getPrepopulatedCommitMessage());
        this.commitMessage.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                CommitDialog.this.validate();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 300;
        this.commitMessage.setLayoutData((Object)data);
        IContextService service = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        this.contextActivation = service.activateContext(COMMIT_DIALOG_CONTEXT_ID);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) {
                CommitDialog.this.okPressed();
                return null;
            }
        };
        this.commitHandler = handlerService.activateHandler(PERFORM_COMMIT_COMMAND_ID, (IHandler)handler, (Expression)new ActiveShellExpression(this.getShell()));
    }

    public boolean close() {
        IContextService service;
        if (this.contextActivation != null) {
            service = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
            service.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
        if (this.commitHandler != null) {
            service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            service.deactivateHandler(this.commitHandler);
            this.commitHandler.getHandler().dispose();
            this.commitHandler = null;
        }
        return super.close();
    }

    private Table createTable(Composite composite, final boolean staged) {
        Table table = new Table(composite, 68098);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 250;
        table.setLayoutData((Object)data);
        String[] titles = new String[]{" ", Messages.CommitDialog_PathColumnLabel};
        int[] widths = new int[]{20, 250};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            ++i;
        }
        List changedFiles = this.gitRepository.index().changedFiles();
        Collections.sort(changedFiles);
        for (ChangedFile file : changedFiles) {
            boolean match = false;
            if (staged && file.hasStagedChanges()) {
                match = true;
            } else if (!staged && file.hasUnstagedChanges()) {
                match = true;
            }
            if (!match) continue;
            this.createTableItem(table, file, false);
        }
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DragSource source = new DragSource((Control)table, 2);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                DragSource ds = (DragSource)event.widget;
                CommitDialog.this.draggingFromTable = ds.getControl();
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StructuredSelection((Object[])((Table)CommitDialog.this.draggingFromTable).getSelection()));
                LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
            }

            public void dragSetData(DragSourceEvent event) {
            }
        });
        DropTarget target = new DropTarget((Control)table, 2);
        target.setTransfer(types);
        if (table.getItemCount() == 0) {
            target.setDropTargetEffect(null);
        }
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dropAccept(DropTargetEvent event) {
                DropTarget dp = (DropTarget)event.widget;
                if (dp.getControl() == CommitDialog.this.draggingFromTable) {
                    event.detail = 0;
                }
            }

            public void dragEnter(DropTargetEvent event) {
                int i = 0;
                int n = event.dataTypes.length;
                while (i < n) {
                    if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                    }
                    ++i;
                }
                event.operations = 2;
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 8;
            }

            public void drop(DropTargetEvent event) {
                if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)event.data;
                CommitDialog.this.moveItems(!staged, selection.toList().toArray(new TableItem[selection.size()]));
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                if (e.item == null) {
                    return;
                }
                TableItem item = (TableItem)e.item;
                CommitDialog.this.updateDiff(staged, CommitDialog.this.getChangedFile(item));
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Point point;
                if (e.getSource() == null) {
                    return;
                }
                Table table = (Table)e.getSource();
                TableItem item = table.getItem(point = new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                Rectangle imageBounds = item.getBounds(0);
                if (imageBounds.contains(point)) {
                    CommitDialog.this.moveItems(staged, new TableItem[]{item});
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (e.getSource() == null) {
                    return;
                }
                Table table = (Table)e.getSource();
                TableItem[] selected = table.getSelection();
                CommitDialog.this.moveItems(staged, selected);
            }
        });
        table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (event.index != 1) {
                    return;
                }
                event.detail &= 0xFFFFFFEF;
            }
        });
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index != 1) {
                    return;
                }
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                Table theTable = (Table)event.widget;
                int width = theTable.getColumn(event.index).getWidth();
                Point p = event.gc.stringExtent(text);
                if (p.x > width) {
                    text = UIUtils.shortenText((String)text, (int)width);
                }
                event.gc.drawText(text, event.x, event.y, true);
                event.detail &= 0xFFFFFFEF;
            }
        });
        if (!staged) {
            final Table myTable = table;
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    TableItem[] selected = myTable.getSelection();
                    ArrayList<IFile> files = new ArrayList<IFile>();
                    final ArrayList<ChangedFile> changedFiles = new ArrayList<ChangedFile>();
                    TableItem[] tableItemArray = selected;
                    int n = selected.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        ChangedFile file = CommitDialog.this.getChangedFile(item);
                        if (file != null) {
                            changedFiles.add(file);
                            IFile iFile = CommitDialog.this.gitRepository.getFileForChangedFile(file);
                            if (iFile != null) {
                                files.add(iFile);
                            }
                        }
                        ++n2;
                    }
                    ContributionItem ci = new ContributionItem(){

                        public void fill(Menu menu, int index) {
                            MenuItem item = new MenuItem(menu, 0);
                            item.setText(Messages.CommitDialog_RevertLabel);
                            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    final ArrayList<ChangedFile> copy = new ArrayList<ChangedFile>(changedFiles);
                                    for (ChangedFile cf : changedFiles) {
                                        copy.add(cf.clone());
                                    }
                                    CommitDialog.this.gitRepository.index().discardChangesForFiles((Collection)changedFiles);
                                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                        public void run() {
                                            if (CommitDialog.this.fLastDiffFile != null) {
                                                for (ChangedFile file : copy) {
                                                    if (file == null || !file.equals((Object)CommitDialog.this.fLastDiffFile)) continue;
                                                    CommitDialog.this.updateDiff(null, Messages.CommitDialog_NoFileSelected);
                                                }
                                            }
                                            CommitDialog.this.removeDraggedFilesFromSource(CommitDialog.this.unstagedTable, copy);
                                        }
                                    });
                                }
                            });
                        }
                    };
                    manager.add((IContributionItem)ci);
                    manager.add((IContributionItem)new Separator("additions"));
                }
            });
            Menu menu = menuMgr.createContextMenu((Control)table);
            table.setMenu(menu);
        }
        return table;
    }

    private synchronized void unstageFiles(Collection<ChangedFile> files) {
        this.stagedTable.setEnabled(false);
        this.unstagedTable.setEnabled(false);
        final ArrayList<ChangedFile> copy = new ArrayList<ChangedFile>(files);
        Collections.copy(copy, new ArrayList<ChangedFile>(files));
        IStatus status = this.gitRepository.index().unstageFiles(files);
        if (status.isOK()) {
            this.getParentShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CommitDialog.this.toggleStageStatus(copy, false);
                    CommitDialog.this.stagedTable.setEnabled(true);
                    CommitDialog.this.unstagedTable.setEnabled(true);
                }
            });
        } else {
            this.stagedTable.setEnabled(true);
            this.unstagedTable.setEnabled(true);
        }
    }

    private synchronized void stageFiles(Collection<ChangedFile> files) {
        this.stagedTable.setEnabled(false);
        this.unstagedTable.setEnabled(false);
        final ArrayList<ChangedFile> copy = new ArrayList<ChangedFile>(files);
        Collections.copy(copy, new ArrayList<ChangedFile>(files));
        IStatus status = this.gitRepository.index().stageFiles(files);
        if (status.isOK()) {
            this.getParentShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CommitDialog.this.toggleStageStatus(copy, true);
                    CommitDialog.this.stagedTable.setEnabled(true);
                    CommitDialog.this.unstagedTable.setEnabled(true);
                }
            });
        } else {
            this.stagedTable.setEnabled(true);
            this.unstagedTable.setEnabled(true);
        }
    }

    private void toggleStageStatus(Collection<ChangedFile> files, boolean stage) {
        Table to = this.stagedTable;
        Table from = this.unstagedTable;
        if (!stage) {
            from = this.stagedTable;
            to = this.unstagedTable;
        }
        to.setRedraw(false);
        for (ChangedFile changedFile : files) {
            this.createTableItem(to, changedFile, true);
        }
        this.packTable(to);
        to.setRedraw(true);
        this.removeDraggedFilesFromSource(from, files);
        this.workaroundEmptyTableDropEffectBug(from);
        this.validate();
    }

    private void updateDiff(boolean staged, ChangedFile file) {
        String fileExtension;
        if (file == null) {
            return;
        }
        boolean isBrowser = this.diffArea instanceof Browser;
        if (isBrowser && this.gitRepository.index().hasBinaryAttributes(file) && !file.getStatus().equals((Object)ChangedFile.Status.DELETED) && (fileExtension = file.getRelativePath().getFileExtension()) != null) {
            String[] imageExtensions;
            String[] stringArray = imageExtensions = new String[]{"png", "gif", "jpeg", "jpg", "ico"};
            int n = imageExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (fileExtension.equalsIgnoreCase(extension)) {
                    IPath fullPath = this.gitRepository.workingDirectory().append(file.getRelativePath());
                    this.updateDiff(file, "<img src=\"" + fullPath.toOSString() + "\" />");
                    return;
                }
                ++n2;
            }
        }
        if (this.fLastDiffFile != null && file.equals((Object)this.fLastDiffFile)) {
            return;
        }
        String diff = this.gitRepository.index().diffForFile(file, staged, 3);
        if (isBrowser) {
            try {
                diff = DiffFormatter.toHTML(file.getRelativePath().toPortableString(), diff);
            }
            catch (Throwable t) {
                IdeLog.logWarning((Plugin)GitUIPlugin.getDefault(), (String)"Failed to turn diff into HTML", (Throwable)t, (String)"com.aptana.git.core/debug");
            }
        }
        this.updateDiff(file, diff);
    }

    private void updateDiff(ChangedFile file, String diff) {
        if (this.diffArea != null && !this.diffArea.isDisposed()) {
            this.setDiffText(diff);
            this.fLastDiffFile = file;
        }
    }

    private void createTableItem(Table table, ChangedFile file, boolean sort) {
        TableItem item = null;
        if (sort) {
            TableItem[] items = table.getItems();
            int index = 0;
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem existing = tableItemArray[n2];
                String path = existing.getText(1);
                if (file.getRelativePath().toOSString().compareTo(path) < 0) break;
                ++index;
                ++n2;
            }
            item = new TableItem(table, 0, index);
        } else {
            item = new TableItem(table, 0);
        }
        Image image = this.emptyFileImage;
        if (file.getStatus() == ChangedFile.Status.DELETED) {
            image = this.deletedFileImage;
        } else if (file.getStatus() == ChangedFile.Status.NEW) {
            image = this.newFileImage;
        }
        item.setImage(0, image);
        item.setText(1, file.getRelativePath().toOSString());
        item.setData(CHANGED_FILE_DATA_KEY, (Object)file);
    }

    private void packTable(Table table) {
        table.getColumn(0).pack();
        int totalWidth = table.getClientArea().width;
        if (totalWidth > 0) {
            table.getColumn(1).setWidth(totalWidth -= table.getColumn(0).getWidth());
        }
    }

    private void validate() {
        if (this.commitMessage.getText().length() < 1) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.CommitDialog_EnterMessage_Error));
            return;
        }
        if (this.stagedTable.getItemCount() == 0) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.CommitDialog_StageFilesFirst_Error));
            return;
        }
        if (this.gitRepository.hasUnresolvedMergeConflicts()) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.CommitDialog_CannotMerge_Error));
            return;
        }
        this.fMessage = this.commitMessage.getText();
        if (!(this.diffArea instanceof Browser)) {
            this.updateStatus((IStatus)new Status(2, GitUIPlugin.getPluginId(), Messages.CommitDialog_BrowserWidgetFailedMsg));
        } else {
            this.updateStatus(Status.OK_STATUS);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = Messages.CommitDialog_CommitButton_Label;
        } else if (id == 1) {
            label = Messages.CommitDialog_CloseButton_Label;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected void okPressed() {
        List changedFiles;
        this.getButton(1).setEnabled(false);
        this.getButton(0).setEnabled(false);
        IStatus status = this.gitRepository.index().commit(this.getCommitMessage());
        if (status.isOK()) {
            this.commitMessage.setText("");
        }
        if (CollectionsUtil.isEmpty((Collection)(changedFiles = this.gitRepository.index().changedFiles())) && status.isOK()) {
            super.okPressed();
            return;
        }
        Collections.sort(changedFiles);
        this.stagedTable.removeAll();
        this.unstagedTable.removeAll();
        for (ChangedFile file : changedFiles) {
            if (file.hasStagedChanges()) {
                this.createTableItem(this.stagedTable, file, false);
            }
            if (!file.hasUnstagedChanges()) continue;
            this.createTableItem(this.unstagedTable, file, false);
        }
        this.updateStatus(status);
        this.getButton(1).setEnabled(true);
        this.getButton(0).setEnabled(true);
    }

    public String getCommitMessage() {
        return this.fMessage;
    }

    private void removeDraggedFilesFromSource(Table sourceTable, Collection<ChangedFile> draggedFiles) {
        if (draggedFiles == null || draggedFiles.isEmpty()) {
            return;
        }
        TableItem[] items = sourceTable.getItems();
        if (draggedFiles.size() == items.length) {
            sourceTable.setRedraw(false);
            sourceTable.removeAll();
            this.packTable(sourceTable);
            sourceTable.setRedraw(true);
            return;
        }
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            if (draggedFiles.contains(this.getChangedFile(item))) {
                toRemove.add(i);
            }
            ++i;
        }
        int[] primitive = new int[toRemove.size()];
        int x = 0;
        for (Integer object : toRemove) {
            primitive[x++] = object;
        }
        sourceTable.setRedraw(false);
        sourceTable.remove(primitive);
        this.packTable(sourceTable);
        sourceTable.setRedraw(true);
        sourceTable.redraw();
    }

    private ChangedFile getChangedFile(TableItem item) {
        return (ChangedFile)item.getData(CHANGED_FILE_DATA_KEY);
    }

    private void workaroundEmptyTableDropEffectBug(Table sourceDragTable) {
        DropTarget dtarget = (DropTarget)sourceDragTable.getData("DropTarget");
        if (dtarget == null) {
            return;
        }
        if (sourceDragTable.getItemCount() == 0) {
            dtarget.setDropTargetEffect(null);
        } else if (dtarget.getDropTargetEffect() == null) {
            dtarget.setDropTargetEffect((DropTargetEffect)new TableDropTargetEffect(sourceDragTable));
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private void moveItems(boolean staged, TableItem ... selected) {
        HashSet<ChangedFile> selectedFiles = new HashSet<ChangedFile>(selected.length);
        TableItem[] tableItemArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            ChangedFile file = this.getChangedFile(item);
            if (file != null) {
                selectedFiles.add(file);
            }
            ++n2;
        }
        if (selectedFiles.isEmpty()) {
            return;
        }
        if (staged) {
            this.unstageFiles(selectedFiles);
        } else {
            this.stageFiles(selectedFiles);
        }
    }

    private class StagingButtons
    implements SelectionListener {
        private String doAllLabel;
        private String doAllTooltip;
        private String doSelectionLabel;
        private String doSelectionTooltip;
        private Table table;
        private boolean staged;
        private Button doSelectionBt;
        private Button doAllBt;

        protected StagingButtons(Composite parent, String doAllLabel, String doAllTooltip, String doSelectionLabel, String doSelectionTooltip) {
            this.doAllLabel = doAllLabel;
            this.doAllTooltip = doAllTooltip;
            this.doSelectionLabel = doSelectionLabel;
            this.doSelectionTooltip = doSelectionTooltip;
            this.createComponent(parent);
        }

        protected void setTable(Table table, boolean staged) {
            this.table = table;
            this.staged = staged;
            table.addSelectionListener((SelectionListener)this);
            this.updateSelectionButton();
        }

        protected void createComponent(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, true);
            layout.horizontalSpacing = 0;
            layout.marginWidth = 1;
            comp.setLayout((Layout)layout);
            this.doAllBt = new Button(comp, 0x800008);
            this.doAllBt.setLayoutData((Object)new GridData(768));
            this.doAllBt.setText(this.doAllLabel);
            this.doAllBt.setToolTipText(this.doAllTooltip);
            this.doAllBt.addSelectionListener((SelectionListener)this);
            this.doSelectionBt = new Button(comp, 0x800008);
            this.doSelectionBt.setLayoutData((Object)new GridData(768));
            this.doSelectionBt.setText(this.doSelectionLabel);
            this.doSelectionBt.setToolTipText(this.doSelectionTooltip);
            this.doSelectionBt.addSelectionListener((SelectionListener)this);
            Point doAllSize = this.doAllBt.computeSize(-1, -1);
            Point doSelectionSize = this.doSelectionBt.computeSize(-1, -1);
            Point bigger = null;
            bigger = doAllSize.x > doSelectionSize.x ? doAllSize : doSelectionSize;
            GridData data = new GridData(0x1000000, 0x1000000, false, false);
            data.widthHint = bigger.x + 10;
            comp.setLayoutData((Object)data);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source instanceof Table) {
                this.updateSelectionButton();
            } else if (source == this.doAllBt) {
                if (this.table != null) {
                    CommitDialog.this.moveItems(this.staged, this.table.getItems());
                    this.updateSelectionDiff(-1);
                    this.updateSelectionButton();
                }
            } else if (source == this.doSelectionBt && this.table != null) {
                int selectionIndex = this.table.getSelectionIndex();
                TableItem[] selection = this.table.getSelection();
                CommitDialog.this.moveItems(this.staged, selection);
                this.updateSelectionDiff(selectionIndex);
                this.updateSelectionButton();
            }
        }

        private void updateSelectionButton() {
            this.doSelectionBt.setEnabled(this.table.getSelectionCount() > 0);
        }

        private void updateSelectionDiff(int previousSelectionIndex) {
            if (this.table.getItemCount() > 0 && previousSelectionIndex > -1) {
                if (this.table.getItemCount() > previousSelectionIndex) {
                    this.table.select(previousSelectionIndex);
                } else {
                    this.table.select(this.table.getItemCount() - 1);
                }
                ChangedFile file = CommitDialog.this.getChangedFile(this.table.getSelection()[0]);
                CommitDialog.this.updateDiff(this.staged, file);
            } else {
                CommitDialog.this.updateDiff(null, Messages.CommitDialog_NoFileSelected);
            }
        }
    }
}

